/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan
/* - Contents: α׷ A/D CH0 CH1 ä Unlimited scan
/*     ̿Ͽ A/D convert ϰ   Ϸ ϴ Դϴ.
/*      α׷ scan ۸  handlingϴ  ְ
/*     ֽϴ.
/*
/* - Remarks : 
/*     1.   COMI-LX101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMILX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasLX.h"

#define DEV_ID	COMI_LX101
#define NUM_CH	2	/* Number of channels */
#define S_FREQ	1000	/* Scan freq. -> 1000 Hz */
#define MSB		10240	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */

void main (void)
{
	HANDLE hDevice;
	int ch_list[2] = {0, 4};  /* Scan channel list : 0  4 ä */
	FILE *fp;
	short *pScanBuf;
	ULONG c, prv_cnt, cur_cnt;
	UINT idx1, idx2;

	/* Load DLL */
	if(!COMILX_LoadDll()){
		printf("ComidasLX.dll load failure\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMILX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMILX_UnloadDll();
		exit(0);
	}

	printf("A/D Scan Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	
	// Analog Input type 'Single ended' Ѵ. //
	// Differential Է ϰ Ѵٸ AI_SINGLEſ  //
	// AI_DIFF  Ͽ Ѵ.                          //
	COMILX_AD_SetInputType (hDevice, AI_SINGLE);
	
	/* start unlimited scan */
	long act_freq = COMILX_US1_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!\n");
		printf("%s", COMILX_ErrorString (COMILX_LastError())); 
		COMILX_UnloadDevice(hDevice);
		COMILX_UnloadDll();
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	/* Create a file to save data */
	if((fp = fopen ("c:\\ComiUscan.txt", "w")) == NULL){
		printf("͸     ϴ.\nƹŰ  ˴ϴ.\n");
		_getch();
		COMILX_US1_Stop (hDevice, TRUE);
		COMILX_UnloadDevice(hDevice);
		COMILX_UnloadDll();
	}
	fprintf (fp,"   CH0    CH4\n");
	
	pScanBuf = COMILX_US1_GetBuffer(hDevice); // Get scan buffer pointer
	prv_cnt = 0; // initialize count variable
	
	while(!kbhit())
	{
		cur_cnt = COMILX_US1_CurCount (hDevice);
		
		/* prv_cnt   : end count of previously processed data block     */
		/* prv_cnt+1 : initial count of newly scaned data block         */
		/* cur_cnt   : end count of current newly scanned data block    */
		for(c = prv_cnt+1; c <= cur_cnt; c++)
		{
			/* COMILX_US1_SBPos (..) Լ ̿Ͽ  ä ۻ ε ´. */
			/* ̶ ι° Ķʹ äιȣ ƴ϶ ä Ʈ ̴.   */
			/* , CH0 0̰, CH4 1 ȴ.                                     */   
			idx1 = COMILX_US1_SBPos (hDevice, 0, c);
			idx2 = COMILX_US1_SBPos (hDevice, 1, c);

			/* File ͸ Ѵ. Ʒ ڵ Voltage ϴ */
			/*  ƴϰ 0~4095  ȴ.					  */
			fprintf (fp, "%6d %6d\n", pScanBuf[idx1], pScanBuf[idx2]);
		}
		printf("Saved scan count = %u\n", cur_cnt);
		prv_cnt = cur_cnt;
	}
	
	COMILX_US1_Stop (hDevice, TRUE);
	fclose(fp);

	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
